#install.packages("colorspace")
#install.packages("stringi")
#install.packages("ggplot2")

#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("org.Hs.eg.db")
#BiocManager::install("DOSE")
#BiocManager::install("clusterProfiler")
#BiocManager::install("enrichplot")


#library packages
library(clusterProfiler)
library(org.Hs.eg.db)
library(enrichplot)
library(ggplot2)

pvalueFilter=0.05       #p-value filter
qvalueFilter=0.05       #adjusted p-value filter

#define color
colorSel="qvalue"
if(qvalueFilter>0.05){
	colorSel="pvalue"
}

setwd("E:\\metabolism\\LGG\\12.TypeDiff\\enrichment\\enrichGO")        
rt=read.table("interGene.txt", header=F, sep="\t", check.names=F)     #read input file

#Convert gene name to gene id
genes=unique(as.vector(rt[,1]))
entrezIDs=mget(genes, org.Hs.egSYMBOL2EG, ifnotfound=NA)
entrezIDs=as.character(entrezIDs)
gene=entrezIDs[entrezIDs!="NA"]        
#gene=gsub("c\\(\"(\\d+)\".*", "\\1", gene)
write.table(gene,"gene.txt",quote = F,sep = '\t')

gene2=read.table("gene.txt",sep = "\t",header = T,check.names = 1,row.names = 1)
gene=as.vector(gene2[,1])
#GO enrichment analysis
kk=enrichGO(gene=gene, OrgDb=org.Hs.eg.db, pvalueCutoff=1, qvalueCutoff=1, ont="all", readable=T)
GO=as.data.frame(kk)
GO=GO[(GO$pvalue<pvalueFilter & GO$qvalue<qvalueFilter),]
#Save enrichment results
write.table(GO, file="GO.txt", sep="\t", quote=F, row.names = F)

#Define the number of displayed GO
showNum=10
if(nrow(GO)<30){
	showNum=nrow(GO)
}

#barplot
pdf(file="barplot.pdf", width=11, height=8)
bar=barplot(kk, drop=TRUE, showCategory=showNum, label_format=100, split="ONTOLOGY", color=colorSel) + facet_grid(ONTOLOGY~., scale='free')
print(bar)
dev.off()
		
#bubble plot
pdf(file="bubble.pdf", width=11, height=8)
bub=dotplot(kk, showCategory=showNum, orderBy="GeneRatio",  split="ONTOLOGY", color=colorSel) + facet_grid(ONTOLOGY~., scale='free')
print(bub)
dev.off()


